clear all
set more off
cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\"

use wf_step1001.dta, clear
capture log close
log using "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\log_files\step3001.log", replace

*** Population weights
egen sum_age_total = sum(age_total) if smpl2==1, by(year country)
gen pop_wgt =  age_total/sum_age_total

*==============================================================
*				Table 001
*==============================================================

keep if smpl2==1

collapse (sd) sd_ue = ue2_rate (mean) ue2_hyst ue2_rate [aw=pop_wgt], by(country year)

egen temp_sd_ue_1970=mean(sd_ue) if year>=1970 & year<=1974, by(country)
egen sd_ue_1970=mean(temp_sd_ue_1970), by(country)

egen temp_sd_ue_1975=mean(sd_ue) if year>=1975 & year<=1979, by(country)
egen sd_ue_1975=mean(temp_sd_ue_1975), by(country)

egen temp_sd_ue_1980=mean(sd_ue) if year>=1980 & year<=1984, by(country)
egen sd_ue_1980=mean(temp_sd_ue_1980), by(country)

egen temp_sd_ue_1985=mean(sd_ue) if year>=1985 & year<=1989, by(country)
egen sd_ue_1985=mean(temp_sd_ue_1985), by(country)

egen temp_sd_ue_1990=mean(sd_ue) if year>=1990 & year<=1995, by(country)
egen sd_ue_1990=mean(temp_sd_ue_1990), by(country)

egen temp_sd_ue_1989=mean(sd_ue) if year>=1989 & year<=1991, by(country)
egen sd_ue_1989=mean(temp_sd_ue_1989), by(country)

gen D_90_70=sd_ue_1990-sd_ue_1970
gen D_89_70=sd_ue_1989-sd_ue_1970
gen D_85_70=sd_ue_1985-sd_ue_1970
gen D_80_70=sd_ue_1980-sd_ue_1970
gen D_75_70=sd_ue_1975-sd_ue_1970

capture cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\figures"
scatter D_75_70 ue2_hyst  if year==1971, mlabel(country) ///
	xtitle("hysteresis") ytitle("{&sigma}{subscript:1975} - {&sigma}{subscript:1970}", size(large)) ///
	title("Panel A") saving(hyst_A.gph, replace)
	
scatter D_80_70 ue2_hyst  if year==1971, mlabel(country) ///
	xtitle("hysteresis") ytitle("{&sigma}{subscript:1980} - {&sigma}{subscript:1970}", size(large)) ///
	title("Panel B") saving(hyst_B.gph, replace)
	
scatter D_85_70 ue2_hyst  if year==1971, mlabel(country) ///
	xtitle("hysteresis") ytitle("{&sigma}{subscript:1985} - {&sigma}{subscript:1970}", size(large)) ///
	title("Panel C") saving(hyst_C.gph, replace)
	
scatter D_89_70 ue2_hyst  if year==1971, mlabel(country) ///
	xtitle("hysteresis") ytitle("{&sigma}{subscript:1989} - {&sigma}{subscript:1970}", size(large))
	
scatter D_90_70 ue2_hyst  if year==1971, mlabel(country) ///
	xtitle("hysteresis") ytitle("{&sigma}{subscript:1990} - {&sigma}{subscript:1970}", size(large)) ///
	title("Panel D")  saving(hyst_D.gph, replace)

*** REPORTED FIGURE	
graph combine hyst_A.gph hyst_B.gph  hyst_C.gph  hyst_D.gph, rows(2) imargin(tiny)

log close
